#include <string.h>
#include <coleco.h>
#include <getput1.h>

// extern char *get_next_person();

extern const byte NAMERLE[];
extern const byte PATTERNRLE[];
extern const byte COLOR[];
extern const byte SPATTERNRLE[];

static char *name;
static char size;
static unsigned name_offset;
static const unsigned OFFSET_PICTURE = 0x18EC;
static const unsigned OFFSET_NAME = 0x1A10;

static volatile char flag_music;
static volatile char flag_ending;

unsigned int music_timer;

void update_equalizer() {
	byte i;
	byte *ch;
	byte *vol;
	
	ch = (byte*) 0x7035;
	vol = (byte*) 0x7039;
	
	for (i=0; i<3; i++) {
		sprites[i].y = 159;
		sprites[i].x = 80 + (i << 5);
		sprites[i].pattern = 60; /*  = 15*4   */
		sprites[i].colour = 6;
		if ((*ch) != 0xff) {
			sprites[i].pattern = ((*vol)>>2);
		}
		ch += 10;
		vol +=10;
	}
	sprites[3].y = 0xd0;
	put_vram(0x1b00,sprites, 13);
}

void nmi(void) {
	if (flag_music) {
		update_equalizer();
		switch (music_timer) {
			case 2880:
				music_timer = 0;
			case 0:
				mute_all();
				play_sound(1);
				play_sound(2);
				break;
			case 960:
				play_sound(3);
				break;
			case 1920:
				play_sound(4);
				play_sound(6);
				play_sound(8);
				play_sound(11);
				break;
			case 2160:
				play_sound(9);
				break;
			case 2640:
				play_sound(5);
				play_sound(7);
			`	play_sound(10);
				play_sound(12);
				break;
		}
		music_timer++;
	}
}

/*
void clean_up() {
	unsigned picture_offset = OFFSET_PICTURE;
	char i;
	char space_chars[] = {32,32,32,32,32,32,32,32};
	i = 0;
	while (i<6 || i<size) {
		delay(1);
		if (i<size) {
			put_vram(name_offset++,&space_chars,1);
		}
		delay(1);
		if (i<6) {
			put_vram(picture_offset,&space_chars,8);
			picture_offset += 32;
		}
		i++;
	}
}

void display_next() {
	char flag = -1;
	char i;
	char j;
	byte k;
	
	unsigned picture_offset;
	delay(1);
	name = get_next_person();
	name_offset = OFFSET_NAME;
	picture_offset = OFFSET_PICTURE;
	k = 128;
	i = 0;
	size = 0;
	while (flag || (k<176)) {
		if (name[i]!=0) {
			size++;
			i++;
			--name_offset;
			if (name[i]!=0) {
				size++;
				i++;
			}
		}
		delay(1);
		if (k<176) {
			for (j=0;j<8;j++) {
				put_vram(picture_offset++,&k,1);
				k++;
			}
			picture_offset +=24;
		}
		delay(1);
		if (flag) {
			put_vram(name_offset,name,size);
		}
		if (name[i]==0) {flag = 0;}
	}
}
*/

void main(void)
{
	screen_mode_2_text();
	sprites_double();
	screen_off();
	rle2vram(PATTERNRLE,0x0000);
	rle2vram(NAMERLE,0x1800);
	rle2vram(SPATTERNRLE,0x3800);
	load_color(COLOR);
	enable_nmi();
	screen_on();
	flag_music = -1;
loop_next:
	//display_next();
	if (*name=='.') goto end;
	delay(150);
	//clean_up();
	goto loop_next;
end:
	flag_ending = -1;
	if (flag_music) goto end;
	delay(150);
	disable_nmi();
	screen_off();
infiniteloop:
	goto infiniteloop;
}